/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.bali.share.nls.StringUtils;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.validate.CompositeInlineValidator;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.validator.InventoryValidator;
import oracle.install.library.util.InventoryInfo;

@ViewDef(id="InventoryUI")
public class InventoryUI
implements View,
ActionListener {
    private static final Logger logger = Logger.getLogger(InventoryUI.class.getName());
    private Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
    private JPanel rootPanel;
    private JPanel topPanel;
    private JPanel botPanel;
    private JPanel botPanel2;
    private MultilineLabel dialogDescLabel;
    private MultilineLabel operDescLabel;
    private MultilineLabel operDescLabel2;
    private JLabel labelGroupName;
    private JLabel labelGroupName2;
    private JLabel labelInventoryDir;
    private JTextField textInventoryDir;
    private JButton buttonBrowse;
    private JComboBox comboGroupName;
    private JLabel lblGroupName;
    private ArrayList<String> unixGroups;
    private boolean bInventoryLocEdited = false;
    private boolean isUnix;
    private int DEFAULT_MINIMUM_SPACE = 150;
    private InventoryInfo inventoryInfo = InventoryInfo.getInstance();

    public InventoryUI() {
        this.dialogDescLabel = new MultilineLabel();
        this.operDescLabel = new MultilineLabel();
        this.operDescLabel2 = new MultilineLabel();
        this.textInventoryDir = new JTextField();
        this.buttonBrowse = new JButton();
        this.buttonBrowse.addActionListener(this);
        this.labelInventoryDir = new JLabel();
        this.labelGroupName = new JLabel();
        this.labelGroupName2 = new JLabel();
        this.comboGroupName = new JComboBox();
        this.lblGroupName = new JLabel();
        this.lblGroupName.setFocusable(true);
        this.lblGroupName.setEnabled(true);
        this.isUnix = this.inventoryInfo.isUnixGroupNeeded();
        this.getRootPanel();
        this.initView();
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        CentralInventorySettings cenInv = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        if (eventType == EventType.INIT) {
            this.getGroups();
            Object[] osList = this.unixGroups.toArray();
            if (this.comboGroupName != null && this.comboGroupName.getItemCount() == 0) {
                for (int i = 0; i < osList.length; ++i) {
                    this.comboGroupName.addItem(osList[i]);
                }
            }
            String defGroup = null;
            if (cenInv != null) {
                defGroup = cenInv.getGroupOwnership();
            }
            if (cenInv != null && defGroup != null && this.unixGroups.contains(defGroup)) {
                logger.info("Value retrieved of Unix GroupName will be selected:" + defGroup);
                this.comboGroupName.setSelectedItem(defGroup);
            } else {
                String sDefGrp = this.inventoryInfo.getDefaultOrainventoryGroup(cenInv != null ? cenInv.getUsePrimaryGroup() : false);
                if (this.unixGroups.contains(sDefGrp)) {
                    logger.finest("Selecting users Active group name:" + sDefGrp);
                    this.comboGroupName.setSelectedItem(sDefGrp);
                } else {
                    this.comboGroupName.setSelectedIndex(0);
                }
            }
            this.lblGroupName.setText(this.comboGroupName.getSelectedItem().toString());
        }
        if (eventType == EventType.LOAD) {
            if (!this.bInventoryLocEdited && cenInv != null && cenInv.getInventoryLocation() != null) {
                this.textInventoryDir.setText(cenInv.getInventoryLocation());
            }
            if (cenInv.getUsePrimaryGroup()) {
                this.botPanel.setVisible(false);
                this.botPanel2.setVisible(true);
            } else {
                this.botPanel.setVisible(true);
                this.botPanel2.setVisible(false);
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        CentralInventorySettings centralInventory = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
        logger.log(Level.INFO, "Inventory UI Entering processInput");
        centralInventory.setGroupOwnership((String)this.comboGroupName.getSelectedItem());
        centralInventory.setInventoryLocation(this.textInventoryDir.getText());
    }

    public Component getView() {
        return this.getRootPanel();
    }

    public void localize(FlowContext flowContext) {
        if (this.rootPanel != null) {
            this.dialogDescLabel.setText(this.resource.getString("INSTALL_COMMON_INVENTORY_DLG_PROMPT", " You are starting your first installation on this host. Specify a directory for installation metadata files (for example, install log files). This directory is called the \"inventory directory\". The installer automatically sets up subdirectories for each product to contain inventory data. The subdirectory for each product typically requires {0} kilobytes of disk space.", new Object[]{this.DEFAULT_MINIMUM_SPACE}));
            String text = this.resource.getString("INSTALL_COMMON_INVENTORY_DLG_INV_LOCATION_LABEL", "Inventory &Directory*:", new Object[0]);
            SwingUtils.setText((JLabel)this.labelInventoryDir, (String)text);
            String browseBtnText = this.resource.getString("INSTALL_COMMON_BROWSE_BUTTON_LABEL", "B&rowse*", new Object[0]);
            SwingUtils.setText((AbstractButton)this.buttonBrowse, (String)browseBtnText);
            if (this.isUnix) {
                this.operDescLabel.setText(this.resource.getString("INSTALL_COMMON_INVENTORY_DLG_OS_GROUPS_PROMPT", "Specify an operating system group whose members have write permission to the inventory directory (oraInventory).", new Object[0]));
                text = this.resource.getString("INSTALL_COMMON_INVENTORY_DLG_OS_GROUPS_LABEL", "oraInventory &Group Name*:", new Object[0]);
                SwingUtils.setText((JLabel)this.labelGroupName, (String)text);
                this.operDescLabel2.setText(this.resource.getString("INSTALL_COMMON_INVENTORY_DLG_OS_GROUPS_PROMPT2", "Members of the following operating system group will have write permission to the inventory directory (oraInventory).", new Object[0]));
                text = this.resource.getString("INSTALL_COMMON_INVENTORY_DLG_OS_GROUPS_LABEL", "oraInventory &Group Name*:", new Object[0]);
                CentralInventorySettings inventorySettings = (CentralInventorySettings)flowContext.getBean(CentralInventorySettings.class);
                if (inventorySettings.getUsePrimaryGroup()) {
                    this.labelGroupName2.setText(StringUtils.stripMnemonic((String)text));
                } else {
                    SwingUtils.setText((JLabel)this.labelGroupName2, (String)text);
                }
            }
        }
    }

    private void initView() {
        this.textInventoryDir.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() != '\n') {
                    InventoryUI.this.bInventoryLocEdited = true;
                }
            }
        });
        final InventoryValidator ival = new InventoryValidator();
        InlineValidationHelper.registerInlineValidator((Component)this.rootPanel, (Component)this.textInventoryDir, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                StatusMessages messages = new StatusMessages();
                StatusMessage vsm = ival.checkEmptiness(data.toString());
                if (vsm != null) {
                    messages.add((StatusMessage)((ValidationStatusMessage)vsm));
                }
                try {
                    ival.checkInvalidChars(data.toString());
                }
                catch (ValidationException e) {
                    messages.add((StatusMessage)new ValidationStatusMessage(e.getErrorInfo().getMessage()));
                }
                return messages;
            }
        }, (Object)ValidationComponent.FOCUS_CHANGE_VALIDATOR);
        ActiveHelpManager.registerComponent((JComponent)this.textInventoryDir, (String)"InventoryUI.textInventoryDir");
        ActiveHelpManager.registerComponent((JComponent)this.comboGroupName, (String)"InventoryUI.comboGroupName");
    }

    private JPanel getRootPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel();
            this.rootPanel.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.getTopPanel(), (Container)this.rootPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(0, 0, 0, 0));
            if (this.isUnix) {
                LayoutUtils.addComponent((Component)this.getBotPanel(), (Container)this.rootPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(20, 0, 0, 0));
                LayoutUtils.addComponent((Component)this.getBotPanel2(), (Container)this.rootPanel, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(20, 0, 0, 0));
            }
            LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this.rootPanel, (int)0, (int)3, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0, (Insets)new Insets(20, 0, 0, 0));
        }
        return this.rootPanel;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.dialogDescLabel, (Container)this.topPanel, (int)0, (int)0, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent((Component)this.labelInventoryDir, (Container)this.topPanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 10, 5));
            LayoutUtils.addComponent((Component)this.textInventoryDir, (Container)this.topPanel, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 10, 5));
            LayoutUtils.addComponent((Component)this.buttonBrowse, (Container)this.topPanel, (int)2, (int)1, (int)1, (int)1, (int)0, (int)12, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 10, 5));
            this.labelInventoryDir.setLabelFor(this.textInventoryDir);
        }
        return this.topPanel;
    }

    private JPanel getBotPanel() {
        if (this.botPanel == null) {
            this.botPanel = new JPanel();
            this.botPanel.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.operDescLabel, (Container)this.botPanel, (int)0, (int)0, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent((Component)this.labelGroupName, (Container)this.botPanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent((Component)this.comboGroupName, (Container)this.botPanel, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.3f, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            this.labelGroupName.setLabelFor(this.comboGroupName);
        }
        return this.botPanel;
    }

    private JPanel getBotPanel2() {
        if (this.botPanel2 == null) {
            this.botPanel2 = new JPanel();
            this.botPanel2.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.operDescLabel2, (Container)this.botPanel2, (int)0, (int)0, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent((Component)this.labelGroupName2, (Container)this.botPanel2, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent((Component)this.lblGroupName, (Container)this.botPanel2, (int)2, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.3f, (double)0.0);
            this.labelGroupName2.setLabelFor(this.lblGroupName);
        }
        return this.botPanel2;
    }

    private void getGroups() {
        logger.info("Fetching existing Unix Group.");
        this.unixGroups = new ArrayList();
        String[] sGroups = this.inventoryInfo.getOSGroups();
        int nLength = sGroups.length;
        for (int i = 0; i < nLength; ++i) {
            if (this.unixGroups.contains(sGroups[i])) continue;
            logger.finest("Unix Group found:" + sGroups[i]);
            this.unixGroups.add(sGroups[i]);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBrowse) {
            this.browseButtonClicked();
        }
    }

    private void browseButtonClicked() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(this.resource.getString("INSTALL_COMMON_CHOOSE_DIRECTORY_LABEL", "Choose Directory", new Object[0]));
        chooser.setApproveButtonText(this.resource.getString("INSTALL_COMMON_SELECT_LABEL", "Select", new Object[0]));
        String defaultDir = this.textInventoryDir.getText();
        if (defaultDir.length() == 0) {
            defaultDir = File.separator;
        }
        File curDir = new File(defaultDir);
        chooser.setCurrentDirectory(curDir);
        int returnVal = chooser.showOpenDialog(this.rootPanel);
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.textInventoryDir.setText(path);
        }
    }
}

